### 概述
OPCUA是一种用于不同设备和系统之间进行通信的技术规范。通过OPCUA Server，各种设备和系统可以互相交流和共享数据，实现更高效的工业自动化。

**使用场景**

* 广泛应用于工业自动化和物联网领域

**整体架构**
![](https://resource.helplook.net/docker_production/3648ne/article/SstRWzzs/6800ab79c9f8c.png)

**主要功能及产品组件**

注： 本手册中用到的中科时代的软件包，均可以从官网的子页面获取。官网提供的版本可能比本手册中提到的版本更高，一般情况下这不会影响您按照本手册的例子执行相应的操作

* MetaFacture作为OPC UA Server时，可以通过OPC-UA协议来提供Metature PLC 、C++、IO-Task中的变量

* OPCUA Server产品包括一部分组件

| **产品组件**                          | **描述说明**           |
| --------------------------------- | ------------------ |
| cmpsinuaserver\_1.1.2\_amd64.deb  | opcua server RTE组件 |

---

### 安装卸载

**安装要求**

* 中科时代出厂的工智机；

* 工智机可以访问互联网；

* 熟悉基础的Linux操作命令

**安装过程**

**1、工智机端安装OPCUA Server RTE组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

```shell
cd $HOME
sudo dpkg -i cmpsinuaserver_1.1.2_amd64.deb
```
![](https://resource.helplook.net/docker_production/3648ne/article/SstRWzzs/6800ab8c9b053.png)

* 修改RTE的配置文件，在ComponentManger 字段下面加入CmpSinUaServer ——请注意大小写必须与例子中一致！

```shell
sudo nano /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```

```shell
[ComponentManager]
 Component.0=retainDeamon
 Component.1=CmpCanBusUtils
 Component.2=CmpSinsegyeLibs
 Component.3=SinsegyeCmp
 Component.4=CmpSinUaServer
```

* 重启RTE服务，使新加入的CmpSinUaServer被调用

```shell
sudo systemctl restart sinsegyerte.service
```

**更新安装**

**1、升级工智机端OPCUA Server RTE组件**

* 上传新的deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

```shell
cd $HOME
sudo dpkg -i cmpsinuaserver_1.1.2_amd64.deb
```
![](https://resource.helplook.net/docker_production/3648ne/article/SstRWzzs/6800ab9428f7b.png)


* 重启RTE服务，使新升级的CmpSinUaServer被调用

```shell
sudo systemctl restart sinsegyerte.service
```

**卸载过程**

**1、卸载工智机OPCUA Server RTE组件**

* 工智机上执行命令卸载

```shell
sudo dpkg -r cmpsinuaserver
```

* 修改RTE的配置文件，ComponentManger模块下去掉CmpSinUaServer

```shell
sudo nano /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```

* 重启RTE服务

```shell
sudo systemctl restart sinsegyerte.service
```

---
### 技术说明

**快速启动**

**（一）本例软、硬件配置**

**硬件：**

1. SX5100工智机 MetaOS V24.08.15\_SX5

2. Win10 PC

**软件：**

* MetaFacutre V1.0.6.2

* 第三方opcua clinet工具 UaExpert



 **（二）本例实验要求及原理**

* 实验要求：按照“安装卸载”部分中的“安装过程”配置完成OPCUA Server环境

**1、实验原理**
![](https://resource.helplook.net/docker_production/3648ne/article/SstRWzzs/6800ab9c7e338.png)


* 当MetaFacture作为OPC UA Server时，可以通过OPC-UA协议来提供Metature PLC 、C++、IO-Task中的变量;便于工智机和第三方设备通过OPC UA的方式快速通信。

* 上位机和工智机使用EtherNet连接。

* 上位机上，MetaFacture下装工程到工智机。工程中会包含下面的试验操作步骤中的配置。

* 上位机上，使用UaExpert查看工智机上的变量信息。



 **（三）本例实验操作步骤**

**1、OPCUA Server工程配置**

* POU中声明区域中声明一些变量

```shell
Bool1  : BOOL;
BYTE1  : BYTE;
WORD1  : WORD;
DWORD1 : DWORD;
Lword1 : LWORD;
SINT1  : SINT;
USINt1 : USINT;
int1   : INT;
uint1  : UINT;
Dint1  : DINT;
UDint1 : UDINT;
LINT1  : LINT;
ULint1 : ULINT;
STRING1: STRING(20);
WSTRING1: WSTRING;
Real1  : REAL;
Lreal1 : LREAL;
```

* POU中程序区域可以设置声明的变量赋值发生变化；

```shell
bool1:= TRUE;
BYTE1:= BYTE1 +1;
WORD1:= WORD1 +1;
DWORD1:= DWORD1 +1;
Lword1:= LWORD1 +1;
SINT1:= SINT1 +1;
USINt1:= USINT1 +1;
int1:= INT1 +1;
uint1:= UINT1 +1;
Dint1:= DINT1 +1;
UDint1:= UDINT1 +1;
LINT1:= LINT1 +1;
ULint1:= ULINT1 +1;
STRING1:= TO_STRING(real1);
WSTRING1:= TO_WSTRING(LREAL1);
Real1:= REAL1 +1.1;
Lreal1:= LREAL1 +1.12;
```

* 工程中符号配置中勾选POU中新建的变量
![](https://resource.helplook.net/docker_production/3648ne/article/SstRWzzs/6800aba55d59f.png)

* 工程运行后，使用第三方OPCUA Client工具UaExpert连接Server即可以获取到OPCUA Server中的变量信息，可以进行读写操作；
![](https://resource.helplook.net/docker_production/3648ne/article/SstRWzzs/6800ababa62c6.png)


（四）实验注意点

* 要使用opcua server，需要在符号配置中勾选响相应的变量，OPCUA  Clinet才能获取到相关变量；

---
### 功能介绍
OPC UA Server测试支持的数据类型

| 数据类型            | 是否支持 | 数组是否支持 | 结构体是否支持 |
| --------------- | ---- | ------ | ------- |
| BOOL            |支持|支持| 支持|
| BYTE             |支持|支持| 支持|
| WORD             |支持|支持| 支持|
| DWORD           |支持|支持| 支持|
| LWORD            |支持|支持| 支持|
| SINT             |支持|支持| 支持|
| USINT            |支持|支持| 支持|
| INT              |支持|支持| 支持|
| UINT            |支持|支持| 支持|
| DINT            |支持|支持| 支持|
| UDINT           |支持|支持| 支持|
| LINT            |支持|支持| 支持|
| ULINT            |支持|支持| 支持|
| STRING           |支持|支持| 支持|
| WSTRING         |支持|支持| 支持|
| REAL            |支持|支持| 支持|
| LREAL           |支持|支持| 支持|
| DATE             |支持|支持| 支持|
| DATE\_AND\_TIME  |支持|支持| 支持|
| TIME\_OF\_DAY   |支持|支持| 支持|